﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.IO;
using System.Xml.Serialization;
using System.Windows.Forms;

namespace Azyobuzi.りすにんぐついったー
{
    public class LogSettingsManager
    {
        private const string logFilePath = ".\\logs.xml";
        private static LogSettings logSettings = null;
        private static LogSettings LogSettings_
        {
            get
            {
                if (logSettings == null)
                {
                    Load();
                }
                return logSettings;
            }
        }

        public static IList<LogItem> Log
        {
            get
            {
                return LogSettings_.Logs;
            }
        }

        public static Rectangle Bounds
        {
            set
            {
                Location = value.Location;
                Size = value.Size;
            }
            get
            {
                return new Rectangle(Location, Size);
            }
        }

        public static Point Location
        {
            set
            {
                LogSettings_.Location = value;
            }

            get
            {
                return LogSettings_.Location;
            }
        }

        public static Size Size
        {
            set
            {
                LogSettings_.Size = value;
            }
            get
            {
                return LogSettings_.Size;
            }
        }

        public static int BottomPanel
        {
            set
            {
                LogSettings_.Bottom_panel = value;
            }
            get
            {
                return LogSettings_.Bottom_panel;
            }
        }

        public static int MaxCount
        {
            set
            {
                LogSettings_.MaxCount = value;
            }
            get
            {
                return LogSettings_.MaxCount;
            }
        }

        public static bool ShowMessage
        {
            set
            {
                LogSettings_.ShowMessage = value;
            }
            get
            {
                return LogSettings_.ShowMessage;
            }
        }

        public static int C1
        {
            set
            {
                LogSettings_.C1 = value;
            }
            get
            {
                return LogSettings_.C1;
            }
        }

        public static int C2
        {
            set
            {
                LogSettings_.C2 = value;
            }
            get
            {
                return LogSettings_.C2;
            }
        }

        public static int C3
        {
            set
            {
                LogSettings_.C3 = value;
            }
            get
            {
                return LogSettings_.C3;
            }
        }

        public static int C4
        {
            set
            {
                LogSettings_.C4 = value;
            }
            get
            {
                return LogSettings_.C4;
            }
        }

        public static void Load()
        {
            if (File.Exists(logFilePath))
            {
                try
                {
                    using (StreamReader sr = new StreamReader(logFilePath))
                    {
                        XmlSerializer xs = new XmlSerializer(typeof(LogSettings));
                        logSettings = (LogSettings)xs.Deserialize(sr);
                        sr.Close();
                        if (logSettings == null)
                        {  //不正なXMLをデシリアライズするとnullが返ることがある。
                            throw new Exception();
                        }
                    }
                }
                catch
                {
                    MessageBox.Show("設定ファイルが不正です。設定を初期化します。", "エラー", MessageBoxButtons.OK, MessageBoxIcon.Warning);
                    File.Copy(logFilePath, logFilePath + ".backup", true);
                    logSettings = new LogSettings();
                }
            }
            else
            {
                logSettings = new LogSettings();
            }
        }

        public static void AddLog(LogItem o)
        {
            Log.Add(o);

            bool showed = false;
            while (Log.Count > 0 && MaxCount < Log.Count)
            {
                if (ShowMessage && !showed)
                {
                    var result = MessageBox.Show("ログが設定された上限を超えました。削除しますか？", "上限オーバー", MessageBoxButtons.YesNo, MessageBoxIcon.Exclamation);
                    if (result == DialogResult.No) { return; } else { showed = true; }
                }

                Log.RemoveAt(0);
            }
        }

        public static void Save()
        {
            StringWriter strWriter = new StringWriter();
            XmlSerializer xs = new XmlSerializer(typeof(LogSettings));
            xs.Serialize(strWriter, logSettings);
            StringReader strReader = new StringReader(strWriter.ToString());
            strWriter.Close();

            //スタイルシート適用
            using (StreamWriter sw = new StreamWriter(logFilePath, false, Encoding.Unicode))
            {
                sw.WriteLine(strReader.ReadLine());
                sw.WriteLine(@"<?xml-stylesheet href=""http://listwi.sourceforge.jp/logdata_style.xsl"" type=""text/xsl""?>");
                sw.Write(strReader.ReadToEnd());
                sw.Close();
            }
            strReader.Close();
        }

        public class LogSettings
        {
            public LogSettings()
            {
                this.Logs = new List<LogItem>();
                this.Location = new Point(50, 50);
                this.Size = new Size(390, 336);
                this.Bottom_panel = 124;
                this.MaxCount = 50;

                this.C1 = 40;
                this.C2 = 120;
                this.C3 = 65;
                this.C4 = 130;
            }

            [XmlElement("logs")]
            public List<LogItem> Logs { set; get; }

            [XmlElement("location")]
            public Point Location { set; get; }

            [XmlElement("size")]
            public Size Size { set; get; }

            [XmlElement("bottom_panel")]
            public int Bottom_panel { set; get; }

            [XmlElement("max_count")]
            public int MaxCount { set; get; }

            [XmlElement("message")]
            public bool ShowMessage { set; get; }

            //各コラムの幅
            [XmlElement("c1")]
            public int C1 { set; get; }

            [XmlElement("c2")]
            public int C2 { set; get; }

            [XmlElement("c3")]
            public int C3 { set; get; }

            [XmlElement("c4")]
            public int C4 { set; get; }
        }
    }

    public class LogItem
    {
        [XmlElement("date")]
        public DateTime Date { set; get; }

        [XmlElement("success")]
        public bool Success { set; get; }

        [XmlElement("tweet")]
        public string Tweet { set; get; }

        [XmlElement("tweet_id")]
        public string TweetID { set; get; }

        /// <summary>
        /// つぶやき削除を有効にするか
        /// </summary>
        [XmlElement("delete_btn")]
        public bool DeleteBtn { set; get; }

        /// <summary>
        /// 自動投稿かどうか
        /// </summary>
        [XmlElement("auto")]
        public bool Auto { set; get; }
    }
}
